﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#pragma hide=1

//// ***
//// CROP IMAGE

Function/S f_CropOptions()
	string rts	
	rts = "To Image Pixel Readings;"
	if (f_IsStack())
		rts += "\\M1(Shrink to Enclosed Feature;"
	else
		rts += "Shrink to Enclosed Feature;"	
	endif
	return rts
end

// draw tab26 - crop image
Function disp_Tab26Draw(pwidth,pheight, ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset, dtvoffset = 30
	variable tleft = 20
	
	tvoffset = ptabpos + dtvoffset
	
	PopupMenu popupCroponStack_tab26,pos={pwidth-110,tvoffset},size={100,23},title=""
	PopupMenu popupCroponStack_tab26,mode=1,value="This Layer;Each Layer;All Layers;",disable=1
	
	// how?

	tvoffset += 0.8*dtvoffset

	PopupMenu popupCropHow_tab26,pos={tleft,tvoffset},size={125,25},title="How to Crop"
	PopupMenu popupCropHow_tab26,mode=1,value=#"f_CropOptions()",disable=1,proc=X_PopMenuProc
	PopupMenu popupCropHow_tab26, help={"Crop using marquee."}
	
	tvoffset += 0.8*dtvoffset
	
	CheckBox checkresetscale_tab26,pos={tleft+2,tvoffset},size={76,16},title="set (left,top) = (0,0)",value=1, disable=1, help={"Reset the image offset to (0,0)."}
	
	tvoffset += 3*dtvoffset

	Button buttonCropIt_tab26,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Crop", disable=1
 
	return 0
end

Function disp_updateTab26()

	PopupMenu popupCroponStack_tab26, win=$k_fullPanel, disable=(!f_IsStack())
	PopupMenu popupCropHow_tab26, win=$k_fullPanel, disable=0
	Button ButtonCropIt_tab26, win=$k_fullPanel, disable=0

	return 0
end

Function T2_CropIt()

	variable chow, cwhere, reset
	
	ControlInfo/W=$k_fullpanel popupCropHow_tab26
	chow = v_value
	ControlInfo/W=$k_fullpanel popupCroponStack_tab26
	cwhere = v_value
	ControlInfo/W=$k_fullpanel checkresetscale_tab26
	reset = v_value
	
	crop_toMQRegion(chow, cwhere, reset)
	
	return 0
end

Function shrink_toFeature()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile, cwfolder
	
	wave img = $(f_DisplayImageID(3))
	
	variable xposf, yposf
	
	if (f_IsSplit() || f_IsStack())
		return 0
	endif

	xposf = round(hcsr(A,k_imgDisplay))
	if (numtype(xposf)!=0)
		return -1
	endif
	yposf = round(vcsr(A,k_imgDisplay))

	ImageSeedFill/C SeedX=xposf, SeedY=yposf, min=1, max=255, target=0, srcwave=img
	
	wave imgfill = root:M_SeedFill
	
	MatrixOP/O imgdiff = img - imgfill
	ImageTransform/O/F=0 shrinkRect imgdiff
	
	return 0
end

Function crop_toMQRegion(variable how, variable where, variable reset)

	variable cPlane, ic, nPlanes
	variable mqright, mqbottom
	string imgname = f_CurrentImage()
	string wdfstr = f_wdfstr(0)
	string nname = imgname + "_crp", tname
	
	STRUCT S_MarqueeOnPanel mqp
	Sf_GetMQOnPanel(mqp)
	mqright = mqp.left + mqp.width - 1
	mqbottom = mqp.top + mqp.height - 1
	
	wave imgsrc = f_ImgwaveDisplayed()
	
	DFREF cdf = GetDataFolderDFR()
	DFREF wdf = $wdfstr
	
	SetDataFolder wdf
	if (f_IsStack())
		switch(where)
			case 1:		// this layer only
				cPlane = f_PlaneNumber()
				duplicate/O/RMD=[mqp.left,mqright][mqp.top,mqbottom][cPlane,cPlane] imgsrc imgtmp
				redimension/N=(-1,-1) imgtmp
				sprintf tname, "%s_p%03d", nname, cPlane
				duplicate/O imgtmp $tname
				wave imgdup = $tname
				break
			case 2:		// each layer
				nPlanes = DimSize(imgsrc,2)
				for (ic=0;ic<nPlanes;ic+=1)
					duplicate/O/RMD=[mqp.left,mqright][mqp.top,mqbottom][ic,ic] imgsrc imgtmp
					redimension/N=(-1,-1) imgtmp
					sprintf tname, "%s_p%03d", nname, ic
					duplicate/O imgtmp $tname
					wave imgdup = $tname
				endfor
				break
			case 3:		// entire stack
				duplicate/O/RMD=[mqp.left,mqright][mqp.top,mqbottom] imgsrc $nname
				wave imgdup = $nname
				break
		endswitch
	else
		duplicate/O/RMD=[mqp.left,mqright][mqp.top,mqbottom] imgsrc $nname
		wave imgdup = $nname
		switch(how)
			case 1:			// exact
				break
			case 2:			// to smallest region of white
				ImageTransform/F=0 shrinkRect imgdup
				wave M_Shrunk
				duplicate/O M_Shrunk imgdup
				break
		endswitch
	endif
	
	if (reset)
		ic = DimDelta(imgdup,0)
		SetScale/P x, 0,ic, imgdup
		ic = DimDelta(imgdup,1)		
		SetScale/P y, 0,ic, imgdup
	endif
	
	killwaves/Z imgtmp, M_Shrunk
	SetDataFolder cdf
	
	return 0
end
